let examplePayload = {
  "data": {
    "descriptors": [
      {
        "datatype": 11,
        "channel": 0,
        "label": "Température",
        "unit": "°C"
      },
      {
        "datatype": 14,
        "channel": 0,
        "label": "Hauteur de matière",
        "unit": "mm"
      }
    ],
    "records": {
      "2024-08-20T12:00:00.000Z": {
        "0": 21,
        "1": 1000
      },
      "2024-08-21T12:00:00.000Z": {
        "0": 22,
        "1": 1200
      }
    },
    "TZMinutesOffset": -120,
    "TZLabel": "Europe/Paris"
  }
}

// Example of how to use the codec output payload

const records = examplePayload.data.records;

for (const [dateString, record] of Object.entries(records)) {
  const date = new Date(dateString);
  for (const [descriptorIndex, value] of Object.entries(record)) {
    const descriptor = examplePayload.data.descriptors[descriptorIndex];
    const unit = descriptor.unit;
    const datatype = descriptor.datatype;
    const channel = descriptor.channel;
    const label = descriptor.label;
    console.log(`${date.toLocaleString()} - ${label} (id=${datatype}, channel=${channel}) has a value of ${value}${unit ? " " + unit : ""}`)
  }
}